/*
 * Decompiled with CFR 0.152.
 */
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.audio.JavaStreamingAudioPlayer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import javax.sound.sampled.AudioFormat;

public class Client {
    private String serverAddress = Utilities.getProperty("server", "localhost");
    private int serverPort = Utilities.getInteger("port", 5555);
    private static final int AUDIO_BUFFER_SIZE = 256;
    private boolean debug = Utilities.getBoolean("debug");
    private BufferedReader systemInReader;
    private BufferedReader reader;
    private DataInputStream dataReader;
    private PrintWriter writer;
    private AudioPlayer audioPlayer;
    private int sampleRate = Utilities.getInteger("sampleRate", 16000);
    private int sampleSize = 16;
    private byte[] socketBuffer = new byte[256];
    private boolean metrics = Boolean.getBoolean("metrics");
    private long sendTime;
    private long receiveTime;
    private long firstSoundTime;
    private boolean firstByteReceived = false;
    private static final String FIRST_SENTENCE = "Type in what you want me to say.";

    public Client() {
        if (!this.connect()) {
            System.out.println("Error connecting to " + this.serverAddress + " at " + this.serverPort);
            System.exit(1);
        }
        this.audioPlayer = new JavaStreamingAudioPlayer();
        this.audioPlayer.setAudioFormat(new AudioFormat(this.sampleRate, this.sampleSize, 1, true, true));
    }

    private boolean connect() {
        try {
            Socket socket = new Socket(this.serverAddress, this.serverPort);
            this.dataReader = new DataInputStream(socket.getInputStream());
            this.systemInReader = new BufferedReader(new InputStreamReader(System.in));
            this.writer = new PrintWriter(socket.getOutputStream(), true);
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    private String readLine() throws IOException {
        char c;
        StringBuffer buffer = new StringBuffer();
        while ((c = (char)this.dataReader.readByte()) != '\n') {
            if (this.debug) {
                System.out.println(c);
            }
            buffer.append(c);
        }
        int lastCharIndex = buffer.length() - 1;
        byte lastByte = (byte)buffer.charAt(lastCharIndex);
        if (lastByte == 13) {
            return buffer.substring(0, lastCharIndex);
        }
        return buffer.toString();
    }

    private void sendLine(String line) {
        if (this.debug) {
            System.out.println(line);
        }
        if ((line = line.trim()).length() > 0) {
            this.writer.print(line);
            this.writer.print('\n');
            this.writer.flush();
        }
    }

    public void runTTSProtocol() {
        try {
            String readyLine = this.readLine();
            if (readyLine.equals("READY")) {
                String input;
                if (!this.sendTTSRequest(FIRST_SENTENCE)) {
                    return;
                }
                System.out.print("Say       : ");
                while ((input = this.systemInReader.readLine()) != null) {
                    if (input.length() > 0 && !this.sendTTSRequest(input)) {
                        return;
                    }
                    System.out.print("Say       : ");
                }
            }
            this.sendLine("DONE");
            this.audioPlayer.drain();
            this.audioPlayer.close();
            System.out.println("ALL DONE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean sendTTSRequest(String text) {
        if (this.metrics) {
            this.sendTime = System.currentTimeMillis();
            this.firstByteReceived = false;
        }
        this.sendLine("TTS\n" + String.valueOf(this.sampleRate) + "\n" + text + "\n");
        String numberSamplesStr = null;
        int numberSamples = 0;
        do {
            try {
                numberSamplesStr = this.readLine();
                numberSamples = Integer.parseInt(numberSamplesStr);
                if (numberSamples == -2) {
                    System.err.println("Client.sendTTSRequest(): error!");
                    return false;
                }
                if (numberSamples <= 0) continue;
                System.out.println("Receiving : " + numberSamples + " samples");
                this.receiveAndPlay(numberSamples);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } while (numberSamples > 0);
        if (this.metrics) {
            System.out.println("FirstByte : " + (this.receiveTime - this.sendTime) + " ms");
        }
        return true;
    }

    private void receiveAndPlay(int numberSamples) {
        int bytesRemaining = numberSamples;
        this.audioPlayer.begin(0);
        while (bytesRemaining > 0) {
            int bytesToRead = bytesRemaining >= 256 ? 256 : bytesRemaining;
            try {
                int read;
                int nRead = 0;
                do {
                    read = this.dataReader.read(this.socketBuffer, nRead, bytesToRead);
                    if (this.metrics && !this.firstByteReceived) {
                        this.receiveTime = System.currentTimeMillis();
                    }
                    nRead += read;
                } while ((bytesToRead -= read) > 0);
                if (nRead < 0) {
                    System.err.println("error reading samples");
                } else {
                    bytesRemaining -= nRead;
                    if (this.metrics && !this.firstByteReceived) {
                        this.firstSoundTime = System.currentTimeMillis();
                        this.firstByteReceived = true;
                    }
                    this.audioPlayer.write(this.socketBuffer, 0, nRead);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (!this.debug) continue;
            System.out.println("BytesRemaining: " + bytesRemaining);
        }
        this.audioPlayer.end();
        if (this.debug) {
            System.out.println("finished");
        }
    }

    public static void main(String[] argv) {
        Client client = new Client();
        client.runTTSProtocol();
        System.exit(0);
    }
}

